package music;

public class Guitarist extends Musician {
	
	protected String favoriteGuitar;

	public Guitarist(String name, String instrument, String favoriteGuitar) {
		super(name, instrument);
		this.favoriteGuitar = favoriteGuitar;
	}

	public Guitarist() {
		super();
	}
	
	public void printDetails() {
//		System.out.println("Musician: ");
//		System.out.println('\t' + this.name);
//		System.out.println('\t' + this.instrument);
		super.printDetails();
		System.out.println('\t' + this.favoriteGuitar);
	}
	
	@Override
	public String toString() {
		// TODO Auto-generated method stub
//		return super.toString();
//		return super.name + super.instrument;
		return super.toString() + " (favorite guitar: " + this.favoriteGuitar + ")";
	}

	public String getFavoriteGuitar() {
		return favoriteGuitar;
	}

	public void setFavoriteGuitar(String favoriteGuitar) {
		this.favoriteGuitar = favoriteGuitar;
	}

}
